package org.msh.tb.export_rest.core;

/**
 * Listener interface called during the generation of the excel file
 * <p>
 * Created by rmemoria on 9/7/17.
 */
public interface ExcelExportListener {

    /**
     * Called by the excel export service to indicate the position of the importing
     *
     * @param position a number between 0 and 1, where 0 is the beginning of the exporting
     *                 and 1 is its completion
     * @return true if the exporting must continue, or false if it must be canceled
     */
    boolean onProgress(double position);
}
